#!/bin/sh

if [ "$1" = "" ]
    then
    base_dir=$HOME/.nsdi/plugin
    mkdir -p $base_dir
else
    base_dir=$1/nsdi_plugin
fi
    
if [ -f $base_dir ] 
    then
    echo "[$base_dir] is not a directory."
    exit 1
elif [ ! -d $base_dir ]
    then
    mkdir -p $base_dir > /dev/null 2>&1
    if [ $? -ne 0 ]
	then
	echo "Failed to create the directory [$base_dir]."
	exit 1
    fi
fi

## get the os name
os_name=`uname`
if [ "$os_name" = "Linux" ]
then
  plugindir=linux
elif [ "$os_name" = "SunOS" ]
then
## check the release number of the OS.
os_release=`uname -r`
if [ "$os_release" = "5.9" ]
then
  plugindir=solaris9
elif [ "$os_release" = "5.8" ]
then
  plugindir=solaris8
elif [ "$os_release" = "5.7" ]
then
  plugindir=solaris7
elif [ "$os_release" = "5.6" ]
then
  plugindir=solaris26
else
  echo "The program does not support SusOS $os_release."
  exit 1
fi
else
  echo "The program does not support $os_name."
  exit 1
fi

# if plugin directory does not exist, exit with no error.
if [ ! -d plugin ]
    then
    exit 0
fi
cd plugin
for name in *
  do
  if [ -d $name ]
      then
      if [ -f $name/.description ]
	  then
	  if [ "$os_name" = "Linux" ]
	      then
	      echo -n "Do you want to install '"
	  else
	      echo "Do you want to install '\c"
	  fi
	  for line in "`cat "$name/.description"`"
	    do
	    if [ "$os_name" = "Linux" ]
		then
		echo -n $line
	    else
		echo "$line\c"
	    fi
	  done
	  if [ "$os_name" = "Linux" ]
	      then
	      echo -n "' plug-in (y/n)? [Y]:"
	  else
	      echo "' plug-in (y/n)? [Y]:\c"
	  fi
	  read install_plugin
	  if [ "$install_plugin" = "" -o "$install_plugin" = "Y" -o "$install_plugin" = "y" ]
	      then
	      if [ ! -d $base_dir/$name ]
		  then
		  mkdir "$base_dir/$name" > /dev/null 2>&1
		  if [ $? -ne 0 ]
		      then
		      echo " Failed to install plug-in."
		      continue
		  fi
	      fi
	      cp -R $name/common_files/* $base_dir/$name
	      cp $name/$plugindir/* $base_dir
	      
	      echo " Plug-in has been installed successfully."
	      echo
	  fi
      fi
  fi
done
cd ..
