#!/bin/sh

bindir=/usr/local/bin
datadir=/usr/local/share/nsdi

## check root or not
id=`id | awk -F= '{print $2}' | awk -F\( '{print $1}'`
if [ $id -ne 0 ]
then
  echo "You must have root privileges to install NetSpot Device Installer."
  exit 1
fi

## get the os name
os_name=`uname`
if [ "$os_name" = "Linux" ]
then
  nsdicmd=nsdil
  nsdiso=libnsdi.so
  browserpath=/opt/netscape/netscape
elif [ "$os_name" = "SunOS" ]
then
## check the release number of the OS.
os_release=`uname -r`
if [ "$os_release" = "5.9" ]
then
  nsdicmd=nsdi9
  nsdiso=libnsdi9.so
  browserpath=/usr/dt/bin/netscape
elif [ "$os_release" = "5.8" ]
then
  nsdicmd=nsdi8
  nsdiso=libnsdi8.so
  browserpath=/usr/dt/bin/netscape
elif [ "$os_release" = "5.7" ]
then
  nsdicmd=nsdi7
  nsdiso=libnsdi7.so
  browserpath=/usr/dt/bin/hotjava
elif [ "$os_release" = "5.6" ]
then
  nsdicmd=nsdi26
  nsdiso=libnsdi26.so
  browserpath=/usr/dt/bin/hotjava
else
  echo "The program does not support SusOS $os_release."
  exit 1
fi
else
  echo "The program does not support $os_name."
  exit 1
fi

# set program directory
if [ "$os_name" = "Linux" ]
then
echo -n "Enter the location where you want to install NetSpot Device Installer [$bindir]:"
else
echo "Enter the location where you want to install NetSpot Device Installer [$bindir]:\c"
fi
read user_bindir
bindir=${user_bindir:=$bindir}

if [ -f $bindir ]
then
  echo "[$bindir] is not a directory."
  exit 1
elif [ ! -d $bindir ]
then
  mkdir -p $bindir > /dev/null 2>&1
  if [ $? -ne 0 ]
  then
    echo "Failed to create directory [$bindir]."
    exit 1
  fi
fi

# set data directory
if [ "$os_name" = "Linux" ]
then
echo -n "Enter the location where you want to install data files [$datadir]:"
else
echo "Enter the location where you want to install data files [$datadir]:\c"
fi
read user_datadir
datadir=${user_datadir:=$datadir}

if [ -f $datadir ]
then
  echo "[$datadir] is not a directory."
  exit 1
elif [ ! -d $datadir ]
then
  mkdir -p $datadir > /dev/null 2>&1
  if [ $? -ne 0 ]
  then
    echo "Failed to create directory [$datadir]."
    exit 1
  fi
fi

# set web browser
if [ "$os_name" = "Linux" ]
then
echo -n "Enter the path to the Web Browser application [$browserpath]:"
else
echo "Enter the path to the Web Browser application [$browserpath]:\c"
fi
read user_browserpath
browserpath=${user_browserpath:=$browserpath}

if [ ! -x $browserpath ]
then
  echo "Cannot find the specified Web browser."
  exit 1
fi

cp $nsdicmd $bindir
cp $nsdiso $bindir
cp -R bundle/* $datadir

cat > $bindir/nsdi <<EOF
#!/bin/sh
LD_LIBRARY_PATH=$bindir:$LD_LIBRARY_PATH
export LD_LIBRARY_PATH
$bindir/$nsdicmd -d $datadir -b $browserpath
EOF

chmod +x $bindir/nsdi

sh plugin_install.sh $datadir

cat <<EOF

NetSpot Device Installer has been installed to $bindir/nsdi.
To uninstall NetSpot Device Installer, type following commands:
  rm $bindir/nsdi
  rm $bindir/$nsdicmd
  rm $bindir/$nsdiso
  rm -rf $datadir
EOF
